//******************************************************************
//
//  Sample Program for LCD Backlight
//
//  Target Machine : CPT-711
//
//  Function:
//  void lcd_backlit(int state) : Set LCD backlight.
//                   int state  : LCD backlight state 0/1 (off/on)
//       (global) BKLIT_TIMEOUT : duration in unit of second
//
//  SYNTECH INFORMATION CO., LTD.
//
//******************************************************************

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "..\lib\711lib.h"

void main (void)
    {
    char  ckey;

    clr_scr ();
    gotoxy (2, 1);
    puts ("LCD BACKLIGHT TEST");

    gotoxy (2, 3);
    printf ("DURATION:%d SEC", BKLIT_TIMEOUT);

    gotoxy (2, 5);
    puts ("7>BACKLIGHT OFF");
    gotoxy (2, 6);
    puts ("9>BACKLIGHT ON");

    while (1)
        {
        if (ckey = getchar())
            {
            switch (ckey)
                {
                case '7':
                     lcd_backlit (0);
                     break;

                case '9':
                     lcd_backlit (1);
                     break;
                }
            }
        }
    }

//-------------------------------------------------------------------------//
